//
//  RVDeckLinkWrapper.h
//  CommunicationModule
//
//  Created by Greg Harris on 9/7/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum _RVSerialMode {
	RVSerialModeUnknown = 0,
	RVSerialModeController = 1,
	RVSerialModeDevice = 2
} RVSerialMode;

extern NSString *RVDeckLinkWrapperKeyName;
extern NSString *RVDeckLinkWrapperKeySerialPort;
extern NSString *RVDeckLinkWrapperKeySerialMode;
extern NSString *RVDeckLinkWrapperKeyDeckLinkWrapper;

@interface RVDeckLinkWrapper : NSObject {
	id deckLink;
	NSString *serialPortName;
}

+ (NSArray *) deckLinkInterfaces;

- (id)initWithDeckLink:(id)newDeckLink;

- (RVSerialMode) serialMode;
- (NSString *) serialPortName;
- (void) setSerialMode:(RVSerialMode)mode;

@end
